/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.wd.core;

import net.minecraft.network.FriendlyByteBuf;
import net.montoyo.wd.utilities.Util;

public enum JSServerRequest {
    CLEAR_REDSTONE(new Class[0]),
    SET_REDSTONE_AT(Integer.class, Integer.class, Boolean.class);

    private final Class[] requestTypes;

    private JSServerRequest(Class<?> ... requestTypes) {
        this.requestTypes = requestTypes;
    }

    public static JSServerRequest fromID(int id) {
        JSServerRequest[] values = JSServerRequest.values();
        return id >= 0 && id < values.length ? values[id] : null;
    }

    public boolean serialize(FriendlyByteBuf buf, Object[] data) {
        if (data.length != this.requestTypes.length) {
            return false;
        }
        for (int i = 0; i < data.length; ++i) {
            if (data[i].getClass() != this.requestTypes[i]) {
                return false;
            }
            Util.serialize(buf, data[i]);
        }
        return true;
    }

    public Object[] deserialize(FriendlyByteBuf buf) {
        Object[] ret = new Object[this.requestTypes.length];
        try {
            for (int i = 0; i < this.requestTypes.length; ++i) {
                ret[i] = Util.unserialize(buf, this.requestTypes[i]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
        return ret;
    }
}

